// workbench objects
// m.miller 05.06.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 3                  
}                        

#declare show_sky =             1;
#declare show_room =            1;
#declare show_bench =           1;
#declare show_peg_holes =       1;
#declare show_solder_gun =      0;
#declare show_solder_spool =    0;
#declare show_pc_board =        0;
#declare show_jack_box =        0;
#declare show_lid =             0;
#declare show_jack_head =       0; 
#declare show_jack_shell =      0;           
#declare show_breaker_panel =   1;            
#declare show_paper =           1;
#declare show_conduit_pipe =    1;
#declare show_receptical =      1;             
#declare show_push_pin =        1;
#declare show_mannequin =       0; 
#declare show_screwdrivers =    1; 
#declare show_plyers =          1; 
#declare show_vault_boy =       0;  
#declare show_bench_screws =    1; 
#declare show_claw_foot =       1; 
#declare show_mech_eye =        0; 
#declare show_flies =           0;       
#declare show_wrenches =        1;
#declare show_clamps =          1;
#declare show_household_oil =   1;
#declare show_tin_can =         1;
#declare show_nails =           1;
#declare show_propane =         1;
#declare show_shadow_object =   1;     //shadow casting vertical blinds


// -----------------------------------------------------------------------------------------
//                      I N C L U D E S
//------------------------------------------------------------------------------------------ 

#include "camera_lights.inc"
#declare zoom_to = <0,0,0> ;
#declare pos_to = <0,0,0> ;  

 
// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 10 } 
#include "sky/sky.inc"
#if (show_sky) 
    object { bg_sphere (<2000,2000,2000>, <0,100,0>, 250) scale <-1,1,1> } 
#end



// -----------------------------------------------------------------------------------------
//                      S O L D E R   G U N 
//------------------------------------------------------------------------------------------
#if (show_solder_gun) 
    #include "solder_gun/solder_gun_materials.inc"
    #include "solder_gun/solder_gun.inc"
    object { solder_gun rotate <0,-70,0> scale <1.2,1.4,1.2> translate <110,305,-240> } 
#end


// -----------------------------------------------------------------------------------------
//                      S O L D E R   S P O O L
//------------------------------------------------------------------------------------------
#if (show_solder_spool)
    #include "solder_spool/solder_spool.inc"
    object {spool_A scale <1.3,1.3,1.3> rotate <0,-35,0> translate <65,300,-200>  }
    object {spool_A scale <1.3,1.3,1.3> rotate <-90,5,0> translate <200,320,-30>}
#end

// -----------------------------------------------------------------------------------------
//                      B E N C H      -    top at Y 300
//------------------------------------------------------------------------------------------ 
#if (show_bench)
    #include "bench/bench.inc"
    object { bench scale <1,1,1> translate <-70,0,0> }
#end


// -----------------------------------------------------------------------------------------
//                      P C   B O A R D
//------------------------------------------------------------------------------------------
#if (show_pc_board)
    #include "pc_board/pc_board.inc" 
    object { pc_board rotate <-90,0,0> scale <1.12,1.12,1.12> translate <-45,360,-175> }
    //pc board led
    #declare light_led_A =
    light_source {
        <0,0,0> 
        #declare light_color = color red .5 green 0 blue 0 ;                      
        light_color * 100                   
        area_light
        <1, 0, 0> <0, 0, 1>         
        8,8                          
        adaptive 0                    
        jitter                        
        circular                      
        orient 
        fade_distance 3
        fade_power 5                       
       
    }
    light_source { light_led_A  translate <-15,370,-180> }  
#end

// -----------------------------------------------------------------------------------------
//                      F L Y
//------------------------------------------------------------------------------------------
#if (show_flies)
    //#include "fly/fly.inc" 
    //object { fly scale <.2,.2,.2> rotate <0,-50,0>  translate <120,300,-130> }
    //object { fly scale <.2,.2,.2> rotate <0,-120,0> translate <8,1,-60> }
    //object { fly scale <.3,.3,.3> rotate <0,-90,180> translate <180,8,70> }
#end

   
// -----------------------------------------------------------------------------------------
//                      B O X
//------------------------------------------------------------------------------------------
#if (show_jack_box)
    #include "jack_box/jack_box.inc" 
    object { jack_box scale <1,1.1,1> rotate <0,-90,0> translate <-45,300,-130> }

    #declare box_light =
    light_source {
        <0,0,0> 
        #declare light_color = color red .07 green .1 blue .05 ;                      
        light_color * 100                  
        area_light
        <10, 0, 0> <0, 0, 10>         
        array_count, array_count                          
        adaptive 0                    
        jitter                        
        circular                      
        orient                     
        fade_distance 5
        fade_power 2     
        translate <-2,450,-130>
        shadowless
    }   
    box_light

#end




// -----------------------------------------------------------------------------------------
//                      L I D
//------------------------------------------------------------------------------------------
#if (show_lid)
    #include "jack_box/lid.inc"
    object { lid rotate <70,0,0> rotate <0,-11,0>translate <-5,306, -315 >}
#end
           
           

// -----------------------------------------------------------------------------------------
//                      J A C K   H E A D
//------------------------------------------------------------------------------------------
#if (show_jack_head)
    #include "jack_head/jack_head.inc" 
    object { jack_head scale <2.1,1.9,2.1> rotate <0,-70,0> translate <-50,397,-125> }
#end


#if (show_jack_shell)
    #include "jack_head/jack_head.inc" 
    object { jack_head_shell scale <2.5,2.3,2.5> rotate <0,10,0> rotate <0,0,85> rotate <0,0,-5>  rotate <0,-30,0> translate <-230,332,-190> }
#end


// -----------------------------------------------------------------------------------------
//                      R O O M
//------------------------------------------------------------------------------------------
#if (show_room)
    #declare show_ceiling = 1;
    #declare show_beams = 1;
    #include "room/room.inc" 
    object { room no_shadow }
#end


// -----------------------------------------------------------------------------------------
//                      B R E A K E R   P A N E L
//------------------------------------------------------------------------------------------
#if (show_breaker_panel)
    #include "breaker_panel/breaker_panel.inc"
    object {breaker_panel rotate <-90,-90,0> translate <-570,490,-185>}
#end

 
 
// -----------------------------------------------------------------------------------------
//                      P A P E R 
//------------------------------------------------------------------------------------------
#if (show_paper)
    #include "paper/paper.inc"
    object {paper_image_A scale <.8,1,.95> rotate <-90,0,0> translate <140,410,-12.5> }
    //object {paper_image_B scale <.7,.7,.7> rotate <-85,0,0> translate <190,413,-33> }
    //object {paper_image_C scale <1.5,.285,1.2> rotate <0,-40,-2.5> translate <50,307.2,-195> }
    //object { fly scale <.3,.3,.3> rotate <0,185,0>  translate <-15,307.2,-170> }
#end


// -----------------------------------------------------------------------------------------
//                      P U S H   P I N S
//------------------------------------------------------------------------------------------
#if (show_push_pin)
    #include "push_pin/push_pin.inc"
    object {push_pin scale <2,2,2> rotate <-90,10,0> translate <140,460,-17> }
    object {push_pin scale <2,2,2> rotate <-90,10,0> translate <175,450,-14> }
    object {push_pin scale <2,2,2> rotate <-90,10,0> translate <179,420,-14> }
    object {push_pin scale <2,2,2> rotate <-90,10,0> translate <176,400,-14> }
    object {push_pin scale <2,2,2> rotate <-90,10,0> translate <178,393,-14> }
#end

// -----------------------------------------------------------------------------------------
//                      P I P E S
//------------------------------------------------------------------------------------------
#if (show_conduit_pipe)
    #include "conduit_pipe/conduit_pipe.inc" 
        object { conduit_A  translate <65,412,-21> }                                   //vertical pipe at receptical
        object { conduit_A  scale <1.5,1.5,1.5> rotate <0,-90,0> translate <-589,624,-110> } //vertical pipe at breaker 
        object { conduit_A  scale <1.5,1.5,1.5> rotate <0,-90,0> translate <-589,624,-150> } //vertical pipe at breaker
        object { conduit_B  translate <-593,480,-85> }
        object { conduit_B  translate <-593,450,-85> }  
#end

// -----------------------------------------------------------------------------------------
//                      R E C E P T I C A L
//------------------------------------------------------------------------------------------
#if (show_receptical)
    #include "receptical/receptical.inc"
    object {receptical scale <1.3, 1.3, 1.3> rotate <0,0,0> translate <67,390,-30> }
#end


// -----------------------------------------------------------------------------------------
//                      M A N N E Q U I N
//------------------------------------------------------------------------------------------
#if (show_mannequin)
    //--- poses
    // standing = 1;
    // sitting  = 2;
    // balance  = 3;
    // sitting2  = 4; 
    #include "mannequin/mannequin_pose.inc"
    object { mannequin_pose(4) scale <3,3,3> rotate <0,0,0> translate <130,324,-50> }
    //object { mannequin_pose(2) scale <2,2,2> rotate <0,0,0> translate <190,494,-42> }
#end



              
// -----------------------------------------------------------------------------------------
//                      S C R E W  D R I V E R S
//------------------------------------------------------------------------------------------ 
#if (show_screwdrivers)
    #include "screwdrivers/screwdrivers.inc" 

    #declare standard =  1; 
    #declare phillips =  2;
    #declare grip_A   =  1;   //plastic craftsman
    #declare grip_B   =  2;   //plastic craftsman - with blue end
    #declare grip_C   =  3;   //plastic simple
    #declare grip_D   =  4;   //old wood style 
    
    //--- classic craftsman - gold resin and red
    #declare M1 = material {M_glass_gold};    
    #declare M2 = material {M_gold_gloss};
    #declare M3 = material {M_red_gloss}; 
    #declare screwdriver_A = object { make_screwdriver(grip_A,phillips,M1,M2,M3) }
    
    //--- classic craftsman - gold resin and red and blue
    #declare M1 = material {M_glass_gold};    
    #declare M2 = material {M_red_gloss};
    #declare M3 = material {M_blue_charcoal_gloss}; 
    #declare screwdriver_B = object { make_screwdriver(grip_B,phillips,M1,M2,M3) }
    
    //--- simple black and green
    #declare M1 = material {M_black_gloss};    
    #declare M2 = material {M_black_gloss};
    #declare M3 = material {M_sea_green_gloss}; 
    #declare screwdriver_C = object { make_screwdriver(grip_C,phillips,M1,M2,M3) }
    
    //--- simple green resin and yellow
    #declare M1 = material {M_glass_green};    
    #declare M2 = material {M_yellow_gloss};
    #declare M3 = material {M_glass_gold}; 
    #declare screwdriver_D = object { make_screwdriver(grip_C,standard,M1,M2,M3) }
    
    
    //--- old wood style 
    #declare M1 = material {M_wood_handle scale <1,1,1>};    
    #declare M2 = material {M_steel_aged_2 scale <2,4,2>};
    #declare M3 = material {M_steel_aged_2 scale <2,4,2>}; 
    #declare screwdriver_E = object { make_screwdriver(grip_D,standard,M1,M2,M3) }

    //--- peg board
    object { screwdriver_E scale <1.7,1.4,1.7>      rotate <0,-8,0>    translate <-57.5,531,-22>} 
    object { screwdriver_B scale <1.5,1.5,1.5>      rotate <0,0,0>      translate <-39.5,531,-22>}
    object { screwdriver_B scale <1.5,1.4,1.5>      rotate <0,30,0>     translate <-21.5,531,-22>}
    object { screwdriver_B scale <1.5,1.3,1.5>      rotate <0,-10,0>    translate <14.5,531,-22>}

    // bracket_5_loops
    #declare sx = -320.5;
    #declare sy = 532;
    object { screwdriver_D scale <2,2,2> rotate <0,-10,0>   translate <sx -36, sy,-22>}
    object { screwdriver_D scale <2,1.8,2> rotate <0,30,0>    translate <sx -18, sy,-22>}
    object { screwdriver_D scale <2,1.6,2> rotate <0,50,0>    translate <sx,     sy,-22>}
    object { screwdriver_A scale <2,2,2> rotate <0,-30,0>   translate <sx +36, sy,-22>}

    // screwdriver resting on mannequin
    object { screwdriver_A scale <1.7,1.7,1.7> rotate <90,-100,0> translate <90,305.7,-200> }
#end

                      
                      

    
// -----------------------------------------------------------------------------------------
//                      P L Y E R S
//------------------------------------------------------------------------------------------
#if (show_plyers)
    #include "needle_nose_plyer/needle_nose_plyer.inc" 
    #declare open_angle = 4; 
    object { make_needle_nose_plyer(open_angle, 1) scale <1.2,1.2,1.2> rotate <20,0,0,> translate <35,350,-25> }
#end

// -----------------------------------------------------------------------------------------
//                      V A U L T   B O Y
//------------------------------------------------------------------------------------------
#if (show_vault_boy)
    #include "vault_boy/vault_boy.inc"
    //object {vault_boy scale <.8,.8,.8> rotate <0,-28,0> translate <185,480,-60>}
#end
          

// -----------------------------------------------------------------------------------------
//                      B E N C H    S C R E W S 
//------------------------------------------------------------------------------------------
#if (show_bench_screws)
    #include "bench_screws/bench_screws.inc"
    bench_screws
#end

// -----------------------------------------------------------------------------------------
//                      S H E L F   S T U F F
//------------------------------------------------------------------------------------------ 
#if (show_claw_foot)
    #include "claw_foot/claw_foot.inc" 
    object {claw_foot scale <.38,.38,.38> rotate <0,90,0> rotate <0,0,-90> translate<70,492,-41>}
    object {claw_foot scale <.38,.38,.38> rotate <0,90,0> rotate <0,0,-10> translate<135,484,-42>}

    object {claw_foot scale <.65,.65,.65> rotate <0,90,0> rotate <0,0,90> rotate <0,20,0>translate<-90,316,-260>} 
    
    object { claw_ball scale <.8,.8,.8> translate <-250,300,-220> }
#end


// -----------------------------------------------------------------------------------------
//                      E Y E B A L L
//------------------------------------------------------------------------------------------ 
#if (show_mech_eye)
    #include "jack_head/eyeball.inc"

    object { mech_eye scale <20,20,20> rotate <0,80,0> rotate <0,0,90> translate <-320,328,-230> }  
    object { mech_eye scale <20,20,20> rotate <0,-40,0> translate <-190,314,-200> }  

#end



// -----------------------------------------------------------------------------------------
//                     W R E N C H E S
//------------------------------------------------------------------------------------------ 
#if (show_wrenches)
    #include "wrench/wrench_A.inc"
    #include "wrench/wrench_grip.inc"
    #declare wrench_B =
    union {
        object { wrench_A       rotate <0,0,0> translate <0,1,0> }
        object { wrench_grip    rotate <0,0,0> translate <0,1,0> }  
    }
   object {wrench_B scale <1.9,1.9,1.9> rotate <0,0,180> translate <14,456,-31>}
   object {wrench_A scale <1.3,1.3,1.3> rotate <0,0,180> translate <14,454.1,-17>} 
   
   object {wrench_A scale <1.9,1.9,1.9> rotate <90,0,0> rotate <0,-90,0> translate <180,303.5,-260>}
#end


// -----------------------------------------------------------------------------------------
//                      C L A M P S
//------------------------------------------------------------------------------------------ 
#if (show_clamps)
    #include "c_clamp/c_clamp.inc"
    object { c_clamp scale <1,1,1> rotate <-90,0,0> rotate <0,0,8> translate <-6,402,-20>}  
    
    object { c_clamp scale <1.5,1.5,1.5> rotate <-90,0,0> rotate <0,-90,0> translate <-30,222,-290>}
    
#end


// -----------------------------------------------------------------------------------------
//                     H O U S E H O L D   O I L
//------------------------------------------------------------------------------------------
#if (show_household_oil)
    #include "household_oil/household_oil.inc"
    object { household_oil scale <1.5,1.4,1.5> rotate <0,-60,0> translate <40,300,-160>} 
    
    //on shelf
    object { household_oil scale <1,1,1> rotate <0,-60,0> translate <160,480,-50>}  
    object { household_oil_B scale <1,1,1> rotate <0,-60,0> translate <172,480,-55>}
#end


// -----------------------------------------------------------------------------------------
//                     T I N   C A N
//------------------------------------------------------------------------------------------
#if (show_tin_can)
    #include "tin_can/tin_can.inc" 
    object { tin_can scale <1.5,1.5,1.5> rotate <0,-10,0> translate <-65,300,-180> }
#end



// -----------------------------------------------------------------------------------------
//                     N A I L S
//------------------------------------------------------------------------------------------
#if (show_nails)
    #include "nails/nails.inc"
    object { old_nail scale <1.2,1.2,1.2> rotate<-90,0,0> translate <185,472,-100> } 
#end





// -----------------------------------------------------------------------------------------
//                      P R O P A N E    T A N K 
//------------------------------------------------------------------------------------------ 
#if (show_propane)
    #include "propane/propane.inc"
    object { propane_tank scale <1.8,1.8,1.8> rotate <0,-40,0> translate <-18,300,-120>} 
#end







// -----------------------------------------------------------------------------------------
//                      C A M E R A S
//------------------------------------------------------------------------------------------
     
#declare ortho_fov = .5;   
#declare pers_fov = 10;
#declare final_pos = <-140,375,-10>; 


render_plan(ortho_fov,-70,-100)          //--remove sky  

//--- GOOD VIEW
#declare pers_fov = 70;
render_final(pers_fov,final_pos) 

//render_view_A(pers_fov,<0,0,0>)  
//render_view_B(pers_fov,<0,-5,-10>)   
//render_view_C(pers_fov,<-100,350,-10>) 
//render_view_E(pers_fov,<-30,350,-10>) 
//render_front_elev(ortho_fov, 0, 450)   //--remove sky
//render_side_elev(ortho_fov, 0, 450)    //--remove sky

//#declare pers_fov = 30;
//view_zero(pers_fov,<0,0,0>)  

//render_breaker(pers_fov,<-540,490,-100>) 
//render_view_pegboard(pers_fov,<-100,400,-10>) 
//#declare pers_fov = 60;
//render_view_C(pers_fov,<-320,520,-10>) 





//-- zoom to
#declare zoom_to = <0,400,-20>;

#declare cam_angle = 50;
#declare fPos = <250, 380, -420>; 
#declare fPos = <0, 3000, -2000>; 
#declare zoom_to = <-50,470,-125> ;
//camera {  up <0, 1, 0> angle cam_angle location fPos look_at zoom_to }  

 